﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Rozszerzenia
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            MessageBox.Show("SQL Inje'c'tion".UsunApostrof());
            MessageBox.Show("SQL Inje'c'tion".UsunApostrof('#'));
            MessageBox.Show("SQL Inje'c'tion".UsunApostrof(c => (c == '\'') ? '#' : c));

            MessageBox.Show(new Button().TypJakoLancuch());
            new Button().TypJakoLancuch().ShowMessage();
        }
    }

    //delegate char DZmieniacz(char znak);

    static class Rozszerzenia //poniższa klasa nie może być zagnieżdżona w innej
    {
        public static string UsunApostrof(this String argument)
        {
            return argument.Replace('\'', '#');
        }

        public static string UsunApostrof(this String argument, char zamiennik)
        {
            return argument.Replace('\'', zamiennik);
        }

        //public static string UsunApostrof(this String argument, DZmieniacz zmieniacz)
        public static string UsunApostrof(this String argument, Func<char, char> zmieniacz)
        {
            string wynik = "";
            foreach (char znak in argument.ToCharArray())
                wynik += zmieniacz(znak);
            return wynik;
        }

        public static string TypJakoLancuch(this object argument)
        {
            return argument.GetType().FullName;
        }

        public static void ShowMessage(this object argument)
        {
            MessageBox.Show(argument.ToString());
        }
    }
}
